/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Localisation;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanMoc;
import cds.aladin.Source;
import cds.aladin.Tok;
import cds.moc.Healpix;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.moc.TMoc;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class FrameMocFiltering
extends FrameRGBBlink {
    String TITLE;
    String INFO;
    String HELP1;
    String CATPLANE;
    String MOCPLANE;
    String IN;
    String OUT;
    private ButtonGroup cbg;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("MOCFILTERINGTITLE");
        this.INFO = Aladin.chaine.getString("MOCFILTERINGINFO");
        this.HELP1 = Aladin.chaine.getString("MOCHELP");
        this.CATPLANE = Aladin.chaine.getString("MOCFILTERINGCAT");
        this.MOCPLANE = Aladin.chaine.getString("MOCFILTERINGMOC");
        this.IN = Aladin.chaine.getString("MOCFILTERINGIN");
        this.OUT = Aladin.chaine.getString("MOCFILTERINGOUT");
    }

    protected FrameMocFiltering(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return -2;
    }

    @Override
    protected int getNb() {
        return 8;
    }

    @Override
    protected String getLabelSelector(int i) {
        return i == 0 ? this.MOCPLANE : this.CATPLANE;
    }

    @Override
    protected Plan[] getPlan() {
        Vector<Plan> v = this.a.calque.getPlansMoc();
        Vector<Plan> v2 = this.a.calque.getPlans(8);
        if (v == null) {
            v = v2;
        } else if (v2 != null) {
            v.addAll(v2);
        }
        if (v == null) {
            return new Plan[0];
        }
        Object[] pi = new Plan[v.size()];
        v.copyInto(pi);
        return pi;
    }

    @Override
    protected Color getColorLabel(int i) {
        return Color.black;
    }

    @Override
    protected JPanel getAddPanel() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        JPanel p = new JPanel();
        p.setLayout(g);
        this.cbg = new ButtonGroup();
        JPanel pp = new JPanel();
        JRadioButton cb = new JRadioButton(this.IN);
        cb.setActionCommand(this.IN);
        this.cbg.add(cb);
        pp.add(cb);
        cb.setSelected(true);
        cb = new JRadioButton(this.OUT);
        cb.setActionCommand(this.OUT);
        this.cbg.add(cb);
        pp.add(cb);
        c.gridwidth = 0;
        c.weightx = 10.0;
        g.setConstraints(pp, c);
        p.add(pp);
        return p;
    }

    protected PlanCatalog createPlane(String label, PlanMoc pMoc, Plan[] p, boolean lookIn) throws Exception {
        SMoc spaceMoc;
        int mode;
        long t0 = System.currentTimeMillis();
        Coord c = new Coord();
        Healpix hpx = new Healpix();
        Vector<Obj> v = new Vector<Obj>(10000);
        Moc moc = pMoc.moc;
        int n = moc instanceof STMoc ? 2 : (mode = moc instanceof TMoc ? 1 : 0);
        SMoc sMoc = mode == 0 ? (SMoc)moc : (spaceMoc = mode == 2 ? ((STMoc)moc).getSpaceMoc() : null);
        TMoc timeMoc = mode == 1 ? (TMoc)moc : (mode == 2 ? ((STMoc)moc).getTimeMoc() : null);
        for (int i = 0; i < p.length; ++i) {
            Plan pCat = p[i];
            if (pCat == null) continue;
            Iterator<Obj> it = pCat.iterator();
            while (it.hasNext()) {
                Obj o = it.next();
                if (!o.asSource()) continue;
                long npixSpace = -1L;
                boolean in = false;
                if (mode == 0 || mode == 2) {
                    c.al = o.getRa();
                    c.del = o.getDec();
                    if (Double.isNaN(c.al) || Double.isNaN(c.del)) continue;
                    c = Localisation.frameToFrame(c, 0, pMoc.frameOrigin);
                    npixSpace = hpx.ang2pix(29, c.al, c.del);
                    in = spaceMoc.contains(npixSpace);
                    if (in != lookIn) continue;
                }
                if ((mode == 1 || mode == 2) && (in = timeMoc.contains(((Source)o).jdtime)) != lookIn) continue;
                if (mode == 2) {
                    in = ((STMoc)moc).contains(npixSpace, ((Source)o).jdtime);
                }
                if (lookIn != in) continue;
                v.add(o);
            }
        }
        long t1 = System.currentTimeMillis();
        System.out.println("Catalog filtered by MOC in " + (t1 - t0) + "ms");
        return this.a.calque.newPlanCatalogBySources(v, label, false);
    }

    @Override
    protected void submit() {
        try {
            StringBuilder list = null;
            String s = this.cbg.getSelection().getActionCommand();
            boolean lookIn = s.equals(this.IN);
            Plan pMoc = this.getPlan(this.ch[0]);
            if (!pMoc.isMoc()) {
                throw new Exception("Not a MOC");
            }
            String label = "";
            ArrayList<Plan> v = new ArrayList<Plan>();
            for (int i = 1; i < this.ch.length; ++i) {
                Plan pCat = this.getPlan(this.ch[i]);
                if (pCat == null) continue;
                label = label.length() == 0 ? pCat.label : label + ", " + pCat.label;
                v.add(pCat);
                if (list == null) {
                    list = new StringBuilder(Tok.quote(pCat.label));
                    continue;
                }
                list.append(" " + Tok.quote(pCat.label));
            }
            Plan[] plans = new Plan[v.size()];
            v.toArray(plans);
            this.createPlane(label, (PlanMoc)pMoc, plans, lookIn);
            this.a.calque.repaintAll();
            this.hide();
            this.a.console.printCommand("ccat -uniq " + (!lookIn ? "-out " : " ") + Tok.quote(pMoc.label) + (list.length() > 0 ? " " + list.toString() : ""));
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error("Catalog filtering by MOC failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
    }
}

